﻿#region: CMTraceLog Function formats logging in CMTrace style
        function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage, 
		    [Parameter(Mandatory=$false)]
		    $Component, 
		    [Parameter(Mandatory=$false)]
		    [int]$Type,		
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage.Replace("`0","") | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }
try
{
    $tsenv = New-Object -COMObject Microsoft.SMS.TSEnvironment
    $tsBuild = $tsenv.Value("SMSTS_Build") #Get Build Number from TS Variable.
    $RegistryVar = "HKLM:\$($tsenv.Value('RegistryPath'))"
    $registryPath = "$RegistryVar\$tsbuild"
    $LogPath = $tsenv.Value('_SMSTSLogPath')
    $LogFile = "$LogPath\WaaS_PreUpgrade.log"
    $ScriptName = 'Check System Path Variable'
    
}
catch
{
	Write-Output "Not running in a task sequence."
}

if ($tsenv)
    {
    CMTraceLog -Message "----- Starting $ScriptName -----" -Type 1 -LogFile $LogFile
    $envpath = ($env:path).Split(";")

    foreach ($path in $envpath)
        {
        if ($path -eq "C:\WINDOWS\system32"){$Path_System32 = $true}
        if ($path -eq "C:\WINDOWS"){$Path_Windows = $true}
        if ($path -eq "C:\WINDOWS\System32\Wbem"){$Path_Wbem = $true}
        if ($path -eq "C:\WINDOWS\System32\WindowsPowerShell\v1.0\"){$Path_PowerhShell = $true}
        }

    if ($Path_System32 -eq $null -or $Path_Windows -eq $null -or $Path_Wbem -eq $null -or $Path_PowerhShell -eq $null )
        {
        $SystemPathStatus = "Fail"
        New-ItemProperty -path $registryPath -Name "CompatScanReturnStatus" -PropertyType String -Value "SystemPathError" -Force
        New-ItemProperty -path $registryPath -Name "CompatScanReturnCode" -PropertyType String -Value "254" -Force
        }
    else
        {$SystemPathStatus = "Pass"}


        $tsenv.Value("SystemPathStatus") = $SystemPathStatus
        New-ItemProperty -Path $registryPath -Name "SystemPathStatus" -Value $SystemPathStatus -Force
        

    Write-Output "System Path Status: $SystemPathStatus"
    write-Output $envpath
    CMTraceLog -Message "System Path Status: $($SystemPathStatus)" -Type 1 -LogFile $LogFile
    CMTraceLog -Message "$envpath" -Type 1 -LogFile $LogFile

    CMTraceLog -Message "----- Finished $ScriptName -----" -Type 1 -LogFile $LogFile

    if ($SystemPathStatus -eq "Fail"){Exit 254}
    }